/*
 * Decompiled with CFR 0.152.
 */
package moe.ytonidc.dimensional_stomach;

import java.util.function.Supplier;
import moe.ytonidc.dimensional_stomach.StomachCapability;
import moe.ytonidc.dimensional_stomach.StomachInit;
import moe.ytonidc.dimensional_stomach.StomachMenu;
import moe.ytonidc.dimensional_stomach.StomachSlotManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class StomachNetwork {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dimensional_stomach", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static void register() {
        CHANNEL.registerMessage(packetId++, OpenGuiPacket.class, OpenGuiPacket::encode, OpenGuiPacket::decode, OpenGuiPacket::handle);
    }

    public static void sendOpenGuiPacket(StomachSlotManager.SlotType type) {
        CHANNEL.sendToServer((Object)new OpenGuiPacket(type));
    }

    public static class OpenGuiPacket {
        private final StomachSlotManager.SlotType slotType;

        public OpenGuiPacket(StomachSlotManager.SlotType slotType) {
            this.slotType = slotType;
        }

        public static void encode(OpenGuiPacket packet, FriendlyByteBuf buf) {
            buf.m_130068_((Enum)packet.slotType);
        }

        public static OpenGuiPacket decode(FriendlyByteBuf buf) {
            return new OpenGuiPacket((StomachSlotManager.SlotType)buf.m_130066_(StomachSlotManager.SlotType.class));
        }

        public static void handle(OpenGuiPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    StomachSlotManager manager = StomachCapability.getSlotManager((Player)player);
                    int level = manager.getStomachLevel();
                    int unlocked = manager.getUnlockedSlots();
                    MenuType menuType = switch (packet.slotType) {
                        default -> throw new IncompatibleClassChangeError();
                        case StomachSlotManager.SlotType.RED -> (MenuType)StomachInit.RED_MENU.get();
                        case StomachSlotManager.SlotType.BLUE -> (MenuType)StomachInit.BLUE_MENU.get();
                        case StomachSlotManager.SlotType.YELLOW -> (MenuType)StomachInit.YELLOW_MENU.get();
                    };
                    String titleKey = switch (packet.slotType) {
                        default -> throw new IncompatibleClassChangeError();
                        case StomachSlotManager.SlotType.RED -> "gui.dimensional_stomach.red_title";
                        case StomachSlotManager.SlotType.BLUE -> "gui.dimensional_stomach.blue_title";
                        case StomachSlotManager.SlotType.YELLOW -> "gui.dimensional_stomach.yellow_title";
                    };
                    NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, p) -> new StomachMenu(menuType, windowId, playerInventory, packet.slotType, level, unlocked), (Component)Component.m_237115_((String)titleKey)), buf -> {
                        buf.writeInt(level);
                        buf.writeInt(unlocked);
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

